# In this update of my unit on networks and pagerank, I use the igraph package. 
# This provides a more convenient way to enter graphs, lets me plot them, and
# also gives a suite of tools to evaluate other graph properties.

library(igraph)
source('my_pagerank.R')

g1 = graph.formula(A++B,A++C,B-+C)
plot(g1)
# compute pagerank using igraph's built-in function
page_rank(g1,damping=.999999)

g1 = graph.formula(A++B,A++C,B-+C)
plot(g1)
# verify that my pagerank calculation agrees
my_pagerank(g1)

g2 = graph.formula(A++B,A++C,B-+C)
g2 = add.edges(g2,c(1,1))
plot(g2)
my_pagerank(g2)

g3 = graph.formula(A++B,A++C); plot(g3)
my_pagerank(g3)
my_pagerank(g3,n.step=101)  # after 1 more step, are the probs the same?
my_pagerank(g3,n.step=101,damp=.85)  # damping removes the cyclic behaviour

g4 = graph.formula(A++B,A-+C);plot(g4)
my_pagerank(g4)
my_pagerank(g4,damp=.85) # damping lets you "get out" of C

# graph with unconnected components
g5 = graph.formula(A++B,A++C,B-+C,D++E)
g5 = add.edges(g5,c(4,4))
plot(g5)
my_pagerank(g5)
my_pagerank(g5,start=c(0,0,0,1,0))  # it matters where you start.

# for my powerpoint:
temppar = par(mfrow=c(1,4),mar=c(3,3,1,1))
rbind(my_pagerank(g2),my_pagerank(g3),my_pagerank(g4))
my_pagerank(g5)
par(temppar)

# the original graph we started with....
g6 = graph.formula(
  A-+B,A-+C,B++D,C-+B,C-+E,D-+E,D-+F,E-+F,E++G,E-+H,F++H,G-+A,G++H)
plot(g6)
my_pagerank(g6)
page_rank(g6,damping=.999999)$vector

# what if we remove B->D edge?
g7 = graph.formula(A-+B,A-+C,D-+B,C-+B,C-+E,D-+E,D-+F,E-+F,E++G,E-+H,F++H,
                   G-+A,G++H)
plot(g7)
round(rbind(
  my_pagerank(g6),  # original
  my_pagerank(g7),  # no B->D edge
  page.rank(g7)$vector ),3)  # no B->D edge; with damping
my_pagerank(g7,damp=.85)

# no path back to A now.
g8 = graph.formula(A-+B,A-+C,B++D,C-+B,C-+E,D-+E,D-+F,E-+F,E++G,E-+H,F++H,G++H)
plot(g8)
my_pagerank(g8)
my_pagerank(g8,damp=.85)
page_rank(g8)$vector

kentville = graph.formula(A-+B,B++C,B++D,B-+E,C-+A,D-+H,E-+D,E-+I,F-+E,F++J,
                          G-+C,G-+F,H-+I,I-+J,J-+K,K-+G)
plot(kentville)
junk = my_pagerank(kentville)
round(-sort(-junk),3)
junk = page.rank(kentville,damping=.99999)$vector
round(-sort(-junk),3)




# try some other networks....
library(igraphdata)
data(USairports)
junk = page.rank(USairports)
junk$vector[junk$vector>.01]
#  ANC   LAX   CLT   DTW   MSP   PHL   IAH   ORD   ATL   DEN   DFW   PHX   SLC   FAI   BET 
#0.011 0.012 0.015 0.018 0.020 0.012 0.010 0.020 0.023 0.023 0.012 0.012 0.011 0.013 0.012 
# ANC= Ancorage
# LAX = Los Angeles
# CLT = Charlotte NC
# DTW = Detroit
# MSP = Minneapolis ***
# PHL = Philadelphia
# IAH = Houston
# ORD = chicago ***
# ATL = atlanta ***
# DEN = Denver ***
# DFW = Dallas / Fort Worth
# PHX = Phoenix
# SLC = Salt Lake City
# FAI = Fairbanks
# BET = Bethel AK



