#### Functions requires to make t robustness shiny app work  ####


##### Global parameters  ####

numreps = 2000
mean1 = 10
mean2 = 10

##### Functions needed to create the list of t's ####
#####  Population sampler  #####

# Normal
pop_sampler_normal <- function(sample_size, mean = 10, sd = 5){
  rnorm(n = sample_size, mean = mean, sd = sd)
}

# Skewed right

# try mean = 100 and sd = c(7,70)

pop_sampler_skew_right <- function(sample_size, mean = 10, sd = 5){
  vartemp <- sd^2
  scaletemp <- vartemp/mean  
  shapetemp <- mean/scaletemp
  rgamma(sample_size, shape = shapetemp, scale = scaletemp)
}

# Skewed left

pop_sampler_skew_left <- function(sample_size, mean = 10, sd = 5){
  2 * mean - pop_sampler_skew_right(sample_size, mean, sd)
}

# Chooser
pop_sampler  <- function(type, sample_size, mean, sd){
  switch(type,
         normal = pop_sampler_normal(sample_size, mean, sd),
         right = pop_sampler_skew_right(sample_size, mean, sd),
         left = pop_sampler_skew_left(sample_size, mean, sd))
}

ttest_results <- function(sample1, sample2, var.equal = TRUE) {
  temp <- t.test(sample1, sample2, var.equal = var.equal)
  c(temp$statistic, #p = temp$p.value, 
    pRelative05 = if(temp$p.value<0.05) "LESS THAN" else "GREATER THAN")
}

multiple_tests <- function(numreps, type1, sample_size1, mean1, sd1, type2, sample_size2, mean2, sd2,var.equal = TRUE){
  temp = as.data.frame(t(replicate(numreps, ttest_results(pop_sampler(type1, sample_size1, mean1, sd1), pop_sampler(type2, sample_size2, mean2, sd2),var.equal))), stringsAsFactors = FALSE)
  temp$pRelative05=factor(temp$pRelative05, levels=c("LESS THAN","GREATER THAN"))
  temp
}


#### output functions  ###

#### Plotting a dist of t's  #####

tDistPlotter <- function(tList){
  
  ggplot(tList, aes(x=as.numeric(t), fill = pRelative05)) + geom_histogram(bins=20) + 
    xlab("t") + 
    ylab("Frequency") + 
    theme_minimal() +
    theme(legend.position="none",
          axis.text=element_text(size=14),
          axis.title=element_text(size=16,face="bold")) +
    #scale_fill_manual(values=c("goldenrod1", "firebrick"))
    scale_fill_manual(values=c("darkblue", "lightblue"),drop=FALSE)
}

typeIerror <- function(tlist){
  table(tlist$pRelative05)[[1]]/numreps
}


####  Plotting the two normal distributions from the two populations ####
twoNormalPlotter <- function(mean1, sd1, mean2, sd2, xMin=0, xMax=10){ 
  ggplot(data.frame(x = c(0, 10)), aes(x = x)) +
    stat_function(fun = dnorm, args = list(mean1, sd1),
                  aes(colour = "Population 1"), size = 1.5) +
    stat_function(fun = dnorm, args = list(mean2, sd2),
                  aes(colour = "Population 2"), size = 1.5) +
    scale_x_continuous(name = "X",
                       breaks = seq(xMin, xMax, 2),
                       limits=c(xMin, xMax)) +
    scale_y_continuous(name = "Frequency") +
    scale_colour_manual(values=c("goldenrod1", "firebrick")) +
    theme_bw() +
    theme(axis.line = element_line(size=1, colour = "black"),
          panel.grid.major = element_blank(),
          panel.grid.minor = element_blank(),
          panel.border = element_blank(), 
          panel.background = element_blank(),
          #text=element_text(family="Tahoma"),
          axis.text.x=element_text(colour="black", size = 14),
          axis.text.y=element_text(colour="black", size = 14),
          axis.title = element_text(size=16, face="bold"),
          legend.title=element_blank(),
          legend.text=element_text(size=16),
          legend.position = "bottom") 
}

